<?php
/*
  ###########################################################
  # PRODUCT NAME: 	iRestora PLUS - Next Gen Restaurant POS
  ###########################################################
  # AUTHER:		Doorsoft
  ###########################################################
  # EMAIL:		info@doorsoft.co
  ###########################################################
  # COPYRIGHTS:		RESERVED BY Door Soft
  ###########################################################
  # WEBSITE:		http://www.doorsoft.co
  ###########################################################
  # This is Waste_model Model
  ###########################################################
 */
class Waste_model extends CI_Model {

    /**
     * get Ingredient List
     * @access public
     * @return object
     * @param no
     */
    public function getIngredientList() {
        $outlet_id = $this->session->userdata('outlet_id');
        $company_id = $this->session->userdata('company_id');
        $this->db->select("tbl_ingredients.id,tbl_ingredients.conversion_rate, tbl_ingredients.name, tbl_ingredients.code, tbl_purchase_ingredients.unit_price as purchase_price, tbl_units.unit_name");
        $this->db->from("tbl_ingredients");
        $this->db->join("tbl_purchase_ingredients", 'tbl_purchase_ingredients.ingredient_id = tbl_ingredients.id', 'left');
        $this->db->join("tbl_units", 'tbl_units.id = tbl_ingredients.unit_id', 'left');
        $this->db->order_by("tbl_ingredients.name", "ASC");
        $this->db->where("tbl_ingredients.company_id", $company_id);
        $this->db->where("tbl_purchase_ingredients.del_status", 'Live');
        $this->db->where("tbl_purchase_ingredients.outlet_id", $outlet_id);
        $result = $this->db->get()->result();
        return $result;
    }
    public function getPurchaseIng($in_id) {
        $outlet_id = $this->session->userdata('outlet_id');
        $this->db->select("tbl_purchase_ingredients.*,tbl_ingredients.conversion_rate");
        $this->db->from("tbl_purchase_ingredients");
        $this->db->join("tbl_ingredients", 'tbl_ingredients.id = tbl_purchase_ingredients.ingredient_id', 'left');
        $this->db->order_by("tbl_purchase_ingredients.id", "DESC");
        $this->db->where("tbl_purchase_ingredients.del_status", 'Live');
        $this->db->where("tbl_purchase_ingredients.outlet_id", $outlet_id);
        $this->db->where("tbl_purchase_ingredients.ingredient_id", $in_id);
        $result = $this->db->get()->row();
        return $result;
    }
    /**
     * get Food Menu List
     * @access public
     * @return object
     * @param no
     */
    public function getFoodMenuList() {
        $outlet_id = $this->session->userdata('outlet_id');
        $company_id = $this->session->userdata('company_id');
        $this->db->select("*");
        $this->db->from("tbl_food_menus");
        $this->db->order_by("tbl_food_menus.name", "ASC");
        $this->db->where("tbl_food_menus.company_id", $company_id);
        $this->db->where("tbl_food_menus.del_status", 'Live');

        $result = $this->db->get()->result();
        return $result;
    }
    /**
     * get Waste Ingredients
     * @access public
     * @return object
     * @param int
     */
    public function getWasteIngredients($id) {
        $this->db->select("*");
        $this->db->from("tbl_waste_ingredients");
        $this->db->order_by('id', 'ASC');
        $this->db->where("waste_id", $id);
        $this->db->where("del_status", 'Live');
        return $this->db->get()->result();
    }
    /**
     * generate Waste Ref No
     * @access public
     * @return object
     * @param int
     */
    public function generateWasteRefNo($outlet_id) {
        $waste_count = $this->db->query("SELECT count(id) as waste_count
               FROM tbl_wastes where outlet_id=$outlet_id")->row('waste_count');
        $ingredient_code = str_pad($waste_count + 1, 6, '0', STR_PAD_LEFT);
        return $ingredient_code;
    }

}

